/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Emios.c
\brief      This file handles Multi-Thread Scheduler timebase
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       5/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#include "Emios.h"


/** Scheduler Callback type */
Emios_CallbackType Emios_Scheduler_CallBack = NULL_PTR;


/*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Sets the function to which the emios interrupt shall \n
              jump once interrupt occurs.
 * \author    R01160
 * \param     Emios_CallbackType - Callback type definition
 * \return    none
 * \warning   this function will skip any null pointer parameter passed \n
              as a input parameter.
 */  
 void vfnEmios_Set_Callback_Fnc(Emios_CallbackType Callback_Fnc)
{
	 #if (PWM_ERROR_DETECT == ON)          /* If Pwm Error Layer Enabled validate errors */	
      if(Callback_Fnc == NULL_PTR)        /* Pwm module already initilized?             */     
      {
         vfnPwm_Report_Error(PWM_CALLBACK_PTR_ID,PWM_E_FNC_CALLBACK_UNINIT); /* Report None initilized module */
      }      
      else
      {
   #endif 
   
     /* Assign Function pointer to call when emios interrupt occurs */
     Emios_Scheduler_CallBack = Callback_Fnc;  
   
     #if (PWM_ERROR_DETECT == ON)      
      }
     #endif 
   
}

/*--------------------------------------------------------------------------------------*/ 
 /**
 * \brief     Emios Channel 0 Interrupt Handler
 * \author    R01160
 * \param     none
 * \return    none
 */  
void Emios_Scheduler_Isr(void)
{
    if (eMIOS_MATCH_EVENT_FLAG(SCHEDULER_EMIOS_CHANNEL) == (uint8_t)1)          
    {
       /* Jump to Scheduler function to perform predefine Tasks */
       Emios_Scheduler_CallBack();
    }
    
     /* Clear interrupt flag */
   eMIOS_MATCH_EVENT_FLAG(SCHEDULER_EMIOS_CHANNEL) = (uint8_t)1;
 
}